using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;
using WindowsApplication1.MCService;

namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string strSessionID;
            IMapCenterServiceservice MC;

            // utworzenie sesji
            MC = new IMapCenterServiceservice();
            MC.Credentials = new NetworkCredential("user", "user");
            strSessionID = MC.CreateSessionID().SessionID;

            TSoapGetAvailableImageFormats__mcsResult gaifRes;
            gaifRes = MC.GetAvailableImageFormats();

            textBox1.Text += "Image formats:\r\n";
            foreach (string S in gaifRes.ImageFormats)
            {
                textBox1.Text += String.Format(" {0}\r\n", S);
            };

            TSoapGetProjections__mcsResult gpRes;
            gpRes = MC.GetProjections();
            textBox1.Text += "Projections:\r\n";
            foreach (string S in gpRes.Projections)
            {
                textBox1.Text += String.Format(" {0}\r\n", S);
            };

            TSoapGetDefaultLayers__mcsResult gdlRes;
            gdlRes = MC.GetDefaultLayers(strSessionID);
            textBox1.Text += "Layers:\r\n";
            foreach (string S in gdlRes.MapLayers)
            {
                textBox1.Text += String.Format(" {0}\r\n", S);
            };

            TSoapRenderMapOnImageByPoint__mcsResult rmoibpRes;
            TSoapTLongLatPoint Mid=new TSoapTLongLatPoint();
            TSoapTImageRenderParams RenderParams=new TSoapTImageRenderParams();
            
            Mid.Longitude=21;
            Mid.Latitude=52+14.0/60;

            RenderParams.Antialiasing=true;
            RenderParams.DPI=96;

            rmoibpRes=MC.RenderMapOnImageByPoint(strSessionID,
                gaifRes.ImageFormats[0], Mid, 400, 0, 0, gpRes.Projections[6], "",
                pictureBox1.Width,pictureBox1.Height,gdlRes.MapLayers,RenderParams);

            pictureBox1.Image = Image.FromStream(new System.IO.MemoryStream(rmoibpRes.BitmapImage));

            TSoapGetDegeocodeLayers__mcsResult sgdlRes;
            sgdlRes = MC.GetDegeocodeLayers(strSessionID);

            TSoapDegeocodeAtPoint__mcsResult sdapRes;
            sdapRes = MC.DegeocodeAtPoint(strSessionID, Mid, 400, 0, 0, 
                gpRes.Projections[6], "", Mid, 400, 10, sgdlRes.DegeocodeLayers, 
                true, false);
            textBox1.Text += "Degeocode result:\r\n";
            textBox1.Text += String.Format(" Country: {0}\r\n", sdapRes.AreaName0);
            textBox1.Text += String.Format(" Adm. level 2: {0}\r\n", sdapRes.AreaName1);
            textBox1.Text += String.Format(" Adm. level 3: {0}\r\n", sdapRes.AreaName2);
            textBox1.Text += String.Format(" Adm. level 4: {0}\r\n", sdapRes.AreaName3);
            textBox1.Text += String.Format(" ZIP: {0}\r\n", sdapRes.Zip);
            foreach (TSoapTDegeocodeCityElementResult S in sdapRes.City)
            {
                textBox1.Text += String.Format(" City: {0}\r\n", S.Name);
            };
            foreach (TSoapTDegeocodeRoadElementResult S in sdapRes.Road)
            {
                textBox1.Text += String.Format(" Road: {0} ({1,2:f}km)\r\n", S.Name, S.FoundLength / 1000);
            };
            foreach (TSoapTDegeocodeRoadElementResult S in sdapRes.InternationalRoad)
            {
                textBox1.Text += String.Format(" International road: {0}\r\n", S.Name);
            };
            foreach (TSoapTDegeocodeAtPointResult S in sdapRes.Natural)
            {
                textBox1.Text += String.Format(" Natural: {0} - {1}\r\n", S.Category, S.Name);
            };
            foreach (TSoapTDegeocodeAtPointDatabaseResult S in sdapRes.DatabaseElements)
            {
                textBox1.Text += String.Format(" Database elements: {0} - {1}\r\n", S.Category, S.Name);
            };
            foreach (TSoapTDegeocodeAtPointResult S in sdapRes.OtherMapElements)
            {
                textBox1.Text += String.Format(" Other map elements: {0} - {1}  ({2,2:f}km)\r\n", 
                    S.Category, S.Name, S.FoundLength / 1000);
            };

            // zamknicie sesji
            MC.DropSession(strSessionID);
        }
    }
}