using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WindowsApplication1.MCService;

namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        private MCServerCore MC;
        public TSoapTLongLatPoint Mid;
        private double Alt = 400;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            MC = new MCServerCore();
            Mid = new TSoapTLongLatPoint();
            Mid.Longitude = 21;
            Mid.Latitude = 52 + 14.0 / 60;
            PaintMapImage();
            timerKeepSession.Enabled = true;
        }

        private void pictureBox1_Resize(object sender, EventArgs e)
        {
            PaintMapImage();
        }

        public void PaintMapImage()
        {
            pictureBox1.Image = MC.GetMapFromPoint(Mid, Alt, pictureBox1.Width, pictureBox1.Height);
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void searchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form2 AForm = new Form2();
            System.Windows.Forms.DialogResult Res;

            AForm.MC = MC;
            Res = AForm.ShowDialog();
            AForm.MC = null;

            if ((Res == System.Windows.Forms.DialogResult.OK) && (Mid != null))
            {
                Mid = AForm.MidPoint;
                PaintMapImage();
            }
        }

        private void timerKeepSession_Tick(object sender, EventArgs e)
        {
            MC.KeepSession();
        }

        private void geocodeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bool DoReport = false;
            Form3 AForm = new Form3();
            AForm.MC = MC;
            AForm.ShowDialog();
            if (AForm.MidPoint != null) Mid = AForm.MidPoint;
            DoReport = AForm.RouteCalculated;
            AForm.MC = null;
            PaintMapImage();
            if (DoReport) ShowRouteReport();
        }

        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            double dx = 0, dy = 0, lon1 = 0, lat1 = 0, lon2 = 0, lat2 = 0;
            const double ScreenDelta = 0.25, Step = 0.33;

            if (e.Button == MouseButtons.Left)
            {
                if (e.X > (double)pictureBox1.Width * (1.0 - ScreenDelta)) dx = Step;
                else
                    if (e.X < (double)pictureBox1.Width * ScreenDelta) dx = -Step;
                if (e.Y > (double)pictureBox1.Height * (1 - ScreenDelta)) dy = Step;
                else
                    if (e.Y < (double)pictureBox1.Height * ScreenDelta) dy = -Step;

                MC.ConvertScreenToMap(0, 0, pictureBox1.Width - 1, pictureBox1.Height - 1,
                    Mid.Longitude, Mid.Latitude, Alt, pictureBox1.Width, pictureBox1.Height,
                    ref lon1, ref lat1, ref lon2, ref lat2);

                Mid.Longitude += (lon2 - lon1) * dx;
                Mid.Latitude += (lat2 - lat1) * dy;
                PaintMapImage();
            }
            if (e.Button == MouseButtons.Right)
            {
                MC.ConvertScreenToMap(e.X, e.Y, 0, 0,
                    Mid.Longitude, Mid.Latitude, Alt, pictureBox1.Width, pictureBox1.Height,
                    ref lon1, ref lat1, ref lon2, ref lat2);
                string MsgText = "";
                MsgText = MC.DegeocodeAtPoint(lon1, lat1, Alt);
                MessageBox.Show(MsgText);
            }
        }

        private void Form1_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (e.KeyCode == Keys.Add)
            {
                Alt /= 2;
                if (Alt < 400) Alt = 400;
                PaintMapImage();
            };
            if (e.KeyCode == Keys.Subtract)
            {
                Alt *= 2;
                PaintMapImage();
            }
        }

        private void ShowRouteReport()
        {
            Form4 AForm = new Form4();
            AForm.MC = MC;
            AForm.ShowDialog();
            AForm.MC = null;
        }

        private void tiledMapToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form5 AForm = new Form5();
            if (AForm.ShowDialog() == DialogResult.OK)
            {
                byte[][] ImageData=null;
                double x1=0, x2=0, y1=0, y2=0;

                MC.LL2XY(Mid.Longitude, Mid.Latitude, AForm.Zoom, ref x1, ref x2, ref y1, ref y2);
                MC.RenderTiledMap((int)x1, (int)y1, AForm.Zoom, ref ImageData);
                int i = 0;
                foreach (byte[] Img in ImageData)
                {
                    System.IO.FileStream aFile;
                    aFile = new System.IO.FileStream(AForm.FolderPath+"\\img"+i.ToString()+".png", System.IO.FileMode.Create);
                    aFile.Write(Img,0,Img.Length);
                    aFile.Close();
                    i++;
                }
            }
        }

    }
}