using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WindowsApplication1.MCService;

namespace WindowsApplication1
{
    public partial class Form2 : Form
    {
        public TSoapTLongLatPoint MidPoint;
        public MCServerCore MC;
        public int LastActiveControl=0;
        
        public Form2()
        {
            InitializeComponent();
        }

        private void Form2_FormClosed(object sender, FormClosedEventArgs e)
        {
            MidPoint = null;
            if (LastActiveControl == 1)
                MC.AddCityToSelection(listCities.SelectedIndex >= 0 ? listCities.SelectedIndex : 0, ref MidPoint);
            if (LastActiveControl == 2)
                MC.AddObjectToSelection(listObjects.SelectedIndex >= 0 ? listObjects.SelectedIndex : 0, ref MidPoint);
        }

        private void Form2_Shown(object sender, EventArgs e)
        {
            MC.SearchInitialize(checkBox1.Checked);
            LoadStaticLists();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            MC.SearchInitialize(checkBox1.Checked);
            textCity.Clear();
            textObject.Clear();
            listCities.Items.Clear();
            listObjects.Items.Clear();
            LoadStaticLists();
        }

        private void LoadStaticLists()
        {
            string[] Arr=null;

            MC.SearchGetCountryList(ref Arr);
            comboCountries.Items.Clear();
            foreach (string S in Arr) comboCountries.Items.Add(S);
            comboCountries.SelectedIndex = 46; // Poland

            MC.SearchGetItemKindList(ref Arr);
            comboItemKinds.Items.Clear();
            foreach (string S in Arr) comboItemKinds.Items.Add(S);
            comboItemKinds.SelectedIndex = 6; // roads and streets
        }

        private void textCity_TextChanged(object sender, EventArgs e)
        {
            timerCity.Enabled = false; timerCity.Enabled = true;
        }

        private void textObject_TextChanged(object sender, EventArgs e)
        {
            timerObject.Enabled = false; timerObject.Enabled = true;
        }

        private void timerObject_Tick(object sender, EventArgs e)
        {
            DoObjectSearch();
        }

        private void DoObjectSearch()
        {
            timerObject.Enabled = false;
            int ObjectCount;

            ObjectCount = MC.SearchSelectItems(
                listCities.SelectedIndex >= 0 ? listCities.SelectedIndex : 0,
                comboItemKinds.SelectedIndex >= 0 ? comboItemKinds.SelectedIndex : 0, 
                textObject.Text);

            string[] Objects = null;
            MC.SearchGetItemsList(0, ObjectCount, ref Objects);

            listObjects.Items.Clear();
            foreach (string S in Objects) listObjects.Items.Add(S);
        }

        private void timerCity_Tick(object sender, EventArgs e)
        {
            DoCitySearch();
        }

        private void DoCitySearch()
        {
            timerCity.Enabled = false;
            int CityCount;

            CityCount = MC.SearchSelectCities(comboCountries.SelectedIndex, 
                textCity.Text, "", "", "", "");

            string[] Cities = null;
            string[][] Adm = null;
            MC.SearchGetCityList(0, CityCount, ref Cities, ref Adm);

            listCities.Items.Clear();
            for (int I = 0; I < Cities.Length; I++)
            {
                string S = "";
                S = Cities[I];
                foreach (string A in Adm[I])
                    if (A != "") S += " (" + A + ")";
                listCities.Items.Add(S);
            }
        }

        private void listCities_SelectedIndexChanged(object sender, EventArgs e)
        {
            DoObjectSearch();
        }

        private void comboCountries_SelectedIndexChanged(object sender, EventArgs e)
        {
            DoCitySearch();
        }

        private void comboItemKinds_SelectedIndexChanged(object sender, EventArgs e)
        {
            DoObjectSearch();
        }

        private void listCities_Enter(object sender, EventArgs e)
        {
            LastActiveControl = 1;
        }

        private void textCity_Enter(object sender, EventArgs e)
        {
            LastActiveControl = 1;
        }

        private void textObject_Enter(object sender, EventArgs e)
        {
            LastActiveControl = 2;
        }

        private void listObjects_Enter(object sender, EventArgs e)
        {
            LastActiveControl = 2;
        }

    }
}