using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WindowsApplication1.MCService;

namespace WindowsApplication1
{
    public partial class Form3 : Form
    {
        public MCServerCore MC=null;
        public TSoapTLongLatPoint MidPoint=null;
        public bool RouteCalculated = false;

        public Form3()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            TSoapTLongLatPoint MidPoint=null;
            ListViewItem Item=new ListViewItem();
            int GeoLevel;
            GeoLevel = MC.Geocode(textCountry.Text, textCounty.Text, textDistrict.Text, 
                textCity.Text, textZIP.Text, textStreet.Text, textStreetNum.Text, ref MidPoint);
            Item.Text = textCountry.Text;
            Item.SubItems.Add(textCity.Text);
            Item.SubItems.Add(textStreet.Text);
            if (MidPoint != null)
            {
                Item.SubItems.Add(MidPoint.Longitude.ToString());
                Item.SubItems.Add(MidPoint.Latitude.ToString());
            }
            else
            {
                Item.SubItems.Add("---");
                Item.SubItems.Add("---");
            };

            string S = "";
            if ((GeoLevel & 1) != 0) S += "[Country]";
            if ((GeoLevel & 2) != 0) S += "[County]";
            if ((GeoLevel & 4) != 0) S += "[District]";
            if ((GeoLevel & 8) != 0) S += "[City]";
            if ((GeoLevel & 16) != 0) S += "[ZIP]";
            if ((GeoLevel & 32) != 0) S += "[Street]";
            if ((GeoLevel & 64) != 0) S += "[Num]";
            Item.SubItems.Add(S);

            listView1.Items.Add(Item);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            MC.LocalizeNumFieldsAdd("Longitude", true);
            MC.LocalizeNumFieldsAdd("Latitude", true);
            MC.LocalizeStrFieldsAdd("Geocode", true);

            if (MessageBox.Show("Do you want all points in single path?", "Localize type", 
                MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.No)
            {
                for (int I = 0; I < listView1.Items.Count; I++)
                {
                    double Lon, Lat;
                    if (listView1.Items[I].SubItems[2].Text != "---")
                    {
                        Lon = Convert.ToDouble(listView1.Items[I].SubItems[3].Text);
                        Lat = Convert.ToDouble(listView1.Items[I].SubItems[4].Text);
                        MC.LocalizeObjectAdd(I, listView1.Items[I].Text + "\r\n"
                            + listView1.Items[I].SubItems[1].Text + "\r\n"
                            + listView1.Items[I].SubItems[2].Text, false, -1);
                        MC.LocalizeObjectPositionAdd(I, Lon, Lat, 0, 0, "");
                        MidPoint = new TSoapTLongLatPoint();
                        MidPoint.Longitude = Lon;
                        MidPoint.Latitude = Lat;
                    };
                }
            }
            else
            {
                MC.LocalizeIconAdd("c:\\projects\\Doc\\Images\\earth.png",0);
                MC.LocalizeObjectAdd(0, "Object", true, 0);
                for (int I = 0; I < listView1.Items.Count; I++)
                {
                    double Lon, Lat;
                    if (listView1.Items[I].SubItems[2].Text != "---")
                    {
                        Lon = Convert.ToDouble(listView1.Items[I].SubItems[3].Text);
                        Lat = Convert.ToDouble(listView1.Items[I].SubItems[4].Text);
                        MC.LocalizeObjectPositionAdd(0, Lon, Lat, Lon, Lat, listView1.Items[I].SubItems[5].Text);
                        MidPoint = new TSoapTLongLatPoint();
                        MidPoint.Longitude = Lon;
                        MidPoint.Latitude = Lat;
                    };
                }
            }
            Close();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            MidPoint = null;
            MC.RoutePlannerDriverParamsSet();
            MC.RoutePlannerVehicleParamsSet();
            MC.RoutePlannerRoadParamsSet(4, true, 50, 10); // 4 - local road
            for (int I = 0; I < listView1.Items.Count; I++)
            {
                double Lon, Lat;
                if (listView1.Items[I].SubItems[2].Text != "---")
                {
                    Lon = Convert.ToDouble(listView1.Items[I].SubItems[3].Text);
                    Lat = Convert.ToDouble(listView1.Items[I].SubItems[4].Text);
                    MC.RoutePlannerEntryAdd(Lon,Lat);
                };
            }
            MC.RoutePlannerCalculateRoute(0);
            RouteCalculated = true;
            Close();
        }
    }
}