using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace MapClient
{
    public delegate void delegateAppendText(string value);
    public delegate void delegateEnableButton(Button btn, bool value);

    // this class is responsible for handling auxilary application window
    public partial class HelloWindow : Form
    {
        // handle to main application class
        private SimpleMapClient simpleMapClient;

        void appendText(string value)
        {
            textBox.AppendText(value);            
        }

        void enableButton(Button btn, bool value)
        {
            btn.Enabled = value;             
        }

        // the only one constructor
        public HelloWindow(SimpleMapClient _simpleMapClient)
        {
            simpleMapClient = _simpleMapClient;
            InitializeComponent();
        }

        // this method hides the window, but NOT close it
        private void closeButton_Click(object sender, EventArgs e)
        {
            this.Hide(); 
        }

        // this method shows another message to user
        public void addMessage(string message)
        {
//            textBox.AppendText(message);
            this.Invoke(new delegateAppendText(appendText), new object[] { message });
        }

        // this method shows another message to user
        public void addMessageLine(string message)
        {
//            textBox.AppendText(message + Environment.NewLine);
            this.Invoke(new delegateAppendText(appendText), new object[] { message + Environment.NewLine });
        }

        public void setServerName(string serverName)
        {
            serverNameTextBox.Text = serverName;
        }

        public string getServerName()
        {
            return serverNameTextBox.Text;
        }

        public void setServerPort(int portNumber)
        {
            portTextBox.Text = portNumber.ToString();
        }

        public string getServerPort()
        {
            return portTextBox.Text;
        }
        
        public void setUserName(string userName)
        {
            userNameTextBox.Text = userName;

        }

        public string getUserName()
        {
            return userNameTextBox.Text;
        }

        public string getUserPassword()
        {
            return userPasswordTextBox.Text;
        }

        public void enableConnect()
        {
            this.Invoke(new delegateEnableButton(enableButton), new object[] { connectButton, true });
        }

        // this method tries to establish connection to server and shows main window if succeeded 
        private void connectButton_Click(object sender, EventArgs e)
        {
            this.Invoke(new delegateEnableButton(enableButton), new object[] { connectButton, false });
            if (simpleMapClient.connectToServer())
            {
                this.Invoke(new delegateEnableButton(enableButton), new object[] { hideButton, true });                
                new Thread(new ParameterizedThreadStart(SimpleMapClient.mainWindowThreadMethod)).Start(simpleMapClient);
            }
            else
            {
                this.Invoke(new delegateEnableButton(enableButton), new object[] { connectButton, true });
                this.Invoke(new delegateEnableButton(enableButton), new object[] { hideButton, false });
            }
        }

        // this is method is invoked during window closing
        private void HelloWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!connectButton.Enabled)
           {
//                this.Hide();
                e.Cancel = true;
            }
        }

    }
}